#include "ByteWriter.h"

namespace xel {
	ByteWriter::ByteWriter(void *buf) {
		this->m_bytes_write = 0;
		this->m_buf = (uint8_t *)buf;
	}

	ByteWriter::~ByteWriter() {

	}

	int32_t ByteWriter::bytes_write() {
		return m_bytes_write;
	}

	int32_t ByteWriter::write_int32(int32_t i) {
		int32_t pos = m_bytes_write;
		m_buf[pos++] = (i >> 24) & 0xff;
		m_buf[pos++] = (i >> 16) & 0xff;
		m_buf[pos++] = (i >> 8) & 0xff;
		m_buf[pos++] = (i) & 0xff;
		m_bytes_write = pos;
		return 4;
	}

	short ByteWriter::write_int16(short s) {
		int32_t pos = m_bytes_write;
		m_buf[pos++] = (s >> 8) & 0xff;
		m_buf[pos++] = (s) & 0xff;
		m_bytes_write = pos;
		return 2;
	}

	int32_t ByteWriter::write_byte(int8_t s) {
		m_buf[m_bytes_write++] = s;
		return 1;
	}

	int32_t ByteWriter::write_bytes(const void *bytes, int32_t count) {
		memcpy(this->m_buf + m_bytes_write, bytes, count);
		m_bytes_write += count;
		return count;
	}
}