#include <cstdio>
#include "AuthBuffer.h"

static char hexTab[] = {'0', '1', '2', '3', '4', '5', '6', '7',
                        '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

char *toHex(const void *pInBytesBuf, int nInBytesLen) {

    const char *bytes = (const char *) pInBytesBuf;
    char *hexBuf = new char[(nInBytesLen << 1) + 1];
    int index = 0;
    int i;
    for (i = 0; i < nInBytesLen; ++i) {
        hexBuf[index++] = hexTab[(bytes[i] & 0xf0) >> 4]; //high
        hexBuf[index++] = hexTab[bytes[i] & 0x0f]; //low
    }
    hexBuf[index] = '\0';
    return hexBuf;
}

int main() {
    unsigned int bufferLen = 512;
    unsigned char retAuthBuff[512] = {0};

    unsigned int appId = 1400000001;
    const char *roomId = "10001";
    const char *openId = "8899";

    const char *appKey = "ab9c7f0428e321a2";

    int len = GME_AuthBuffer_GenAuthBuffer(appId, roomId, openId,
                                           appKey, retAuthBuff, bufferLen);

    printf("hexStr = %s\n", toHex(retAuthBuff, len));
    return 0;
}
